#ifndef ADS131A04_ADC_ADS131A04_H_
#define ADS131A04_ADC_ADS131A04_H_

// Includes
#include <ti/devices/msp432p4xx/driverlib/driverlib.h>
#include <string.h>
#include "System/timers.h"
#include "System/helpers.h"

#define ADS131A04_STATUS_STRING_LENGTH	        100
#define ADS131A04_MAX_RX_BYTES	                100
//#define ADS131A04_INTERPRET_REGISTER_VALUES     1
#define ADS131A04_DISCARDED_SAMPLES             16
#define ADS131A04_LSB                           0.000000298023223876953125 // [V]

#define ADS131A04_CHANNEL_COUNT     4
#define ADS131A04_REGISTER_COUNT	17

// Register address defines - All registers
#define ADS131A04_ID_MSB_ADDRESS	0x00
#define ADS131A04_ID_LSB_ADDRESS	0x01
#define ADS131A04_STAT_1_ADDRESS	0x02 // Read-only
#define ADS131A04_STAT_P_ADDRESS	0x03
#define ADS131A04_STAT_N_ADDRESS	0x04
#define ADS131A04_STAT_S_ADDRESS	0x05
#define ADS131A04_ERROR_CNT_ADDRESS	0x06
#define ADS131A04_STAT_M2_ADDRESS	0x07
#define ADS131A04_A_SYS_CFG_ADDRESS	0x0B
#define ADS131A04_D_SYS_CFG_ADDRESS	0x0C
#define ADS131A04_CLK1_ADDRESS	    0x0D
#define ADS131A04_CLK2_ADDRESS	    0x0E
#define ADS131A04_ADC_ENA_ADDRESS	0x0F
#define ADS131A04_ADC1_ADDRESS	    0x11
#define ADS131A04_ADC2_ADDRESS	    0x12
#define ADS131A04_ADC3_ADDRESS	    0x13
#define ADS131A04_ADC4_ADDRESS	    0x14

// Register value defines - Only writeable registers
#define ADS131A04_A_SYS_CFG_VALUE	0x60
#define ADS131A04_D_SYS_CFG_VALUE	0x3C
#define ADS131A04_CLK1_VALUE	    0x02
#if (LOW_FREQ_SAMPLING == 1)
#define ADS131A04_CLK2_VALUE	    0x20 // 0x40 pentru 500Hz, 0x20 pentru 1kHz, 0x26 pentru 10.24kHz
#else
#define ADS131A04_CLK2_VALUE        0x26 // 0x40 500Hz, 0x20 1kHz, 0x26 10.24kHz
#endif
#define ADS131A04_ADC_ENA_VALUE     0x00
#define ADS131A04_ADC1_VALUE	    0x00
#define ADS131A04_ADC2_VALUE	    0x00
#define ADS131A04_ADC3_VALUE	    0x00
#define ADS131A04_ADC4_VALUE	    0x00

// Commands
#define ADS131A04_NULL_CMD	    0x0000 // Null command
#define ADS131A04_RESET_CMD	    0x0011 // Software reset
#define ADS131A04_STANDBY_CMD	0x0022 // Enter low-power standby mode
#define ADS131A04_WAKEUP_CMD	0x0033 // Wake-up from standby mode
#define ADS131A04_LOCK_CMD	    0x0555 // Places the interface in a locked state and ignores all commands except NULL, RREGS, and UNLOCK
#define ADS131A04_UNLOCK_CMD	0x0655 // Brings the device out of an unconfigured POR state or a locked state
#define ADS131A04_RREG_CMD	    0x2000 // (001a aaaa nnnnnnnn)b; Read a single register
#define ADS131A04_RREGS_CMD	    0x2000 // (001a aaaa nnnnnnnn)b; Read (nnnn nnnn + 1) registers starting at address a aaaa
#define ADS131A04_WREG_CMD	    0x4000 // (010a aaaa dddddddd)b; Write a single register at address a aaaa with data dddd dddd
#define ADS131A04_WREGS_CMD	    0x6000 // (011a aaaa nnnnnnnn)b; Write (nnnn nnnn + 1) registers beginning at address a aaaa

// Command status responses
#define ADS131A04_READY_RESPONSE	    0xFF00 // (FFdd)h; Fixed-status word stating that the device is in a power-up ready state or standby mode and is ready for use. The least significant byte of the device word indicates the address 0 hardware device ID code (dd)
#define ADS131A04_ACK_RESPONSE	        0x0000 // (cccc)h; Acknowledgment response. The device has received and executed the command and repeats the received command (cccc) as the command status response.
#define ADS131A04_STATUS_REG_RESPONSE	0x2000 // (001a aaaa dddd dddd)b; Status byte update. Register address a aaaa contains data dddd dddd
#define ADS131A04_RREGS_RESPONSE	    0x6000 // (011a aaaa nnnn nnnn)b;Response for read (nnnn nnnn + 1) registers starting at address a aaaa

// Masks/shifts
#define ADS131A04_ID_MSB_NU_CH_MASK         0xFF
#define ADS131A04_ID_MSB_NU_CH_SHIFT        0

#define ADS131A04_ID_LSB_REV_ID_MASK        0xFF
#define ADS131A04_ID_LSB_REV_ID_SHIFT       0

#define ADS131A04_STAT_1_F_OPC_MASK         0x01
#define ADS131A04_STAT_1_F_OPC_SHIFT        6
#define ADS131A04_STAT_1_F_SPI_MASK         0x01
#define ADS131A04_STAT_1_F_SPI_SHIFT        5
#define ADS131A04_STAT_1_F_ADCIN_MASK       0x01
#define ADS131A04_STAT_1_F_ADCIN_SHIFT      4
#define ADS131A04_STAT_1_F_WDT_MASK         0x01
#define ADS131A04_STAT_1_F_WDT_SHIFT        3
#define ADS131A04_STAT_1_F_RESYNC_MASK      0x01
#define ADS131A04_STAT_1_F_RESYNC_SHIFT     2
#define ADS131A04_STAT_1_F_DRDY_MASK        0x01
#define ADS131A04_STAT_1_F_DRDY_SHIFT       1
#define ADS131A04_STAT_1_F_CHECK_MASK       0x01
#define ADS131A04_STAT_1_F_CHECK_SHIFT      0

#define ADS131A04_STAT_P_F_IN4P_MASK        0x01
#define ADS131A04_STAT_P_F_IN4P_SHIFT       3
#define ADS131A04_STAT_P_F_IN3P_MASK        0x01
#define ADS131A04_STAT_P_F_IN3P_SHIFT       2
#define ADS131A04_STAT_P_F_IN2P_MASK        0x01
#define ADS131A04_STAT_P_F_IN2P_SHIFT       1
#define ADS131A04_STAT_P_F_IN1P_MASK        0x01
#define ADS131A04_STAT_P_F_IN1P_SHIFT       0

#define ADS131A04_STAT_N_F_IN4N_MASK        0x01
#define ADS131A04_STAT_N_F_IN4N_SHIFT       3
#define ADS131A04_STAT_N_F_IN3N_MASK        0x01
#define ADS131A04_STAT_N_F_IN3N_SHIFT       2
#define ADS131A04_STAT_N_F_IN2N_MASK        0x01
#define ADS131A04_STAT_N_F_IN2N_SHIFT       1
#define ADS131A04_STAT_N_F_IN1N_MASK        0x01
#define ADS131A04_STAT_N_F_IN1N_SHIFT       0

#define ADS131A04_STAT_S_F_STARTUP_MASK     0x01
#define ADS131A04_STAT_S_F_STARTUP_SHIFT    2
#define ADS131A04_STAT_S_F_CS_MASK          0x01
#define ADS131A04_STAT_S_F_CS_SHIFT         1
#define ADS131A04_STAT_S_F_FRAME_MASK       0x01
#define ADS131A04_STAT_S_F_FRAME_SHIFT      0

#define ADS131A04_ERROR_CNT_ER_MASK         0xFF
#define ADS131A04_ERROR_CNT_ER_SHIFT        0

#define ADS131A04_STAT_M2_M2PIN_MASK        0x03
#define ADS131A04_STAT_M2_M2PIN_SHIFT       4
#define ADS131A04_STAT_M2_M1PIN_MASK        0x03
#define ADS131A04_STAT_M2_M1PIN_SHIFT       2
#define ADS131A04_STAT_M2_M0PIN_MASK        0x03
#define ADS131A04_STAT_M2_M0PIN_SHIFT       0

#define ADS131A04_A_SYS_CFG_VNCPEN_MASK     0x01
#define ADS131A04_A_SYS_CFG_VNCPEN_SHIFT    7
#define ADS131A04_A_SYS_CFG_HRM_MASK        0x01
#define ADS131A04_A_SYS_CFG_HRM_SHIFT       6
#define ADS131A04_A_SYS_CFG_VREF_4V_MASK    0x01
#define ADS131A04_A_SYS_CFG_VREF_4V_SHIFT   4
#define ADS131A04_A_SYS_CFG_INT_REFEN_MASK  0x01
#define ADS131A04_A_SYS_CFG_INT_REFEN_SHIFT 3
#define ADS131A04_A_SYS_CFG_COMP_TH_MASK    0x07
#define ADS131A04_A_SYS_CFG_COMP_TH_SHIFT   0

#define ADS131A04_D_SYS_CFG_WDT_EN_MASK     0x01
#define ADS131A04_D_SYS_CFG_WDT_EN_SHIFT    7
#define ADS131A04_D_SYS_CFG_CRC_MODE_MASK   0x01
#define ADS131A04_D_SYS_CFG_CRC_MODE_SHIFT  6
#define ADS131A04_D_SYS_CFG_DNDLY_MASK      0x03
#define ADS131A04_D_SYS_CFG_DNDLY_SHIFT     4
#define ADS131A04_D_SYS_CFG_HIZDLY_MASK     0x03
#define ADS131A04_D_SYS_CFG_HIZDLY_SHIFT    2
#define ADS131A04_D_SYS_CFG_FIXED_MASK      0x01
#define ADS131A04_D_SYS_CFG_FIXED_SHIFT     1
#define ADS131A04_D_SYS_CFG_CRC_EN_MASK     0x01
#define ADS131A04_D_SYS_CFG_CRC_EN_SHIFT    0

#define ADS131A04_CLK1_CLKSRC_MASK          0x01
#define ADS131A04_CLK1_CLKSRC_SHIFT         7
#define ADS131A04_CLK1_CLK_DIV_MASK         0x07
#define ADS131A04_CLK1_CLK_DIV_SHIFT        1

#define ADS131A04_CLK2_ICLK_DIV_MASK        0x07
#define ADS131A04_CLK2_ICLK_DIV_SHIFT       5
#define ADS131A04_CLK2_OSR_MASK             0x0F
#define ADS131A04_CLK2_OSR_SHIFT            0

#define ADS131A04_ADC_ENA_ENA_MASK          0x0F
#define ADS131A04_ADC_ENA_ENA_SHIFT         0

#define ADS131A04_ADC1_GAIN1_MASK           0x07
#define ADS131A04_ADC1_GAIN1_SHIFT          0

#define ADS131A04_ADC2_GAIN2_MASK           0x07
#define ADS131A04_ADC2_GAIN2_SHIFT          0

#define ADS131A04_ADC3_GAIN3_MASK           0x07
#define ADS131A04_ADC3_GAIN3_SHIFT          0

#define ADS131A04_ADC4_GAIN4_MASK           0x07
#define ADS131A04_ADC4_GAIN4_SHIFT          0

typedef enum
{
    ADS131A04_COMP_TH_HIGH_95_0_LOW_5_0,
    ADS131A04_COMP_TH_HIGH_92_5_LOW_7_5,
    ADS131A04_COMP_TH_HIGH_90_0_LOW_10_0,
    ADS131A04_COMP_TH_HIGH_87_5_LOW_12_5,
    ADS131A04_COMP_TH_HIGH_85_0_LOW_15_0,
    ADS131A04_COMP_TH_HIGH_80_0_LOW_20_0,
    ADS131A04_COMP_TH_HIGH_75_0_LOW_25_0,
    ADS131A04_COMP_TH_HIGH_70_0_LOW_30_0
} ADS131A04_COMP_TH_Values;

typedef enum
{
    ADS131A04_DLY_6_ns,
    ADS131A04_DLY_8_ns,
    ADS131A04_DLY_10_ns,
    ADS131A04_DLY_12_ns
} ADS131A04_DLY_Values;

typedef enum
{
    ADS131A04_CLK_DIV_F_CLKIN_2 = 1,
    ADS131A04_CLK_DIV_F_CLKIN_4,
    ADS131A04_CLK_DIV_F_CLKIN_6,
    ADS131A04_CLK_DIV_F_CLKIN_8,
    ADS131A04_CLK_DIV_F_CLKIN_10,
    ADS131A04_CLK_DIV_F_CLKIN_12,
    ADS131A04_CLK_DIV_F_CLKIN_14
} ADS131A04_CLK_DIV_Values;

typedef enum
{
    ADS131A04_CLK_DIV_F_ICLK_2 = 1,
    ADS131A04_CLK_DIV_F_ICLK_4,
    ADS131A04_CLK_DIV_F_ICLK_6,
    ADS131A04_CLK_DIV_F_ICLK_8,
    ADS131A04_CLK_DIV_F_ICLK_10,
    ADS131A04_CLK_DIV_F_ICLK_12,
    ADS131A04_CLK_DIV_F_ICLK_14
} ADS131A04_ICLK_DIV_Values;

typedef enum
{
    ADS131A04_OSR_F_MOD_4096,
    ADS131A04_OSR_F_MOD_2048,
    ADS131A04_OSR_F_MOD_1024,
    ADS131A04_OSR_F_MOD_800,
    ADS131A04_OSR_F_MOD_768,
    ADS131A04_OSR_F_MOD_512,
    ADS131A04_OSR_F_MOD_400,
    ADS131A04_OSR_F_MOD_384,
    ADS131A04_OSR_F_MOD_256,
    ADS131A04_OSR_F_MOD_200,
    ADS131A04_OSR_F_MOD_192,
    ADS131A04_OSR_F_MOD_128,
    ADS131A04_OSR_F_MOD_96,
    ADS131A04_OSR_F_MOD_64,
    ADS131A04_OSR_F_MOD_48,
    ADS131A04_OSR_F_MOD_32
} ADS131A04_OSR_Values;

typedef enum
{
    ADS131A04_ENA_POWER_DOWN = 0,
    ADS131A04_ENA_POWER_UP = 0xF
} ADS131A04_ENA_Values;

typedef enum
{
    ADS131A04_GAIN_1,
    ADS131A04_GAIN_2,
    ADS131A04_GAIN_4,
    ADS131A04_GAIN_8,
    ADS131A04_GAIN_16
} ADS131A04_GAIN_Values;

// Functions
// General
bool ADS131A04_init(void);
void ADS131A04_null(unsigned char* readData);
bool ADS131A04_reset(void/*unsigned char* readData*/);
bool ADS131A04_standby(void);
bool ADS131A04_wakeup(void);
bool ADS131A04_lock(void/*unsigned char* readData*/);
bool ADS131A04_unlock(void/*unsigned char* readData*/);
bool ADS131A04_read_RevisionID(unsigned char* readData);
bool ADS131A04_read_STAT_1(unsigned char* readData);
bool ADS131A04_read_STAT_P(unsigned char* readData);
bool ADS131A04_read_STAT_N(unsigned char* readData);
bool ADS131A04_read_STAT_S(unsigned char* readData);
bool ADS131A04_read_ErrorCount(unsigned char* readData);
bool ADS131A04_read_STAT_M2(unsigned char* readData);
bool ADS131A04_read_A_SYS_CFG(unsigned char* readData);
bool ADS131A04_read_D_SYS_CFG(unsigned char* readData);
bool ADS131A04_read_CLK1(unsigned char* readData);
bool ADS131A04_read_CLK2(unsigned char* readData);
bool ADS131A04_read_ADC_ENA(unsigned char* readData);
bool ADS131A04_read_ADC1(unsigned char* readData);
bool ADS131A04_read_ADC2(unsigned char* readData);
bool ADS131A04_read_ADC3(unsigned char* readData);
bool ADS131A04_read_ADC4(unsigned char* readData);
const char* ADS131A04_GetStatus(void);
bool ADS131A04_rreg(unsigned char registerAddress, unsigned char* readData);
bool ADS131A04_wreg(unsigned char registerAddress, unsigned char data/*, unsigned char* readData*/);
unsigned char ADS131A04_writeInt(int data, unsigned char bytesNumber);
unsigned char* ADS131A04_read(unsigned char bytesNumber);
bool ADS131A04_sample(unsigned int* readDataCh1, unsigned int* readDataCh2, unsigned int* readDataCh3, unsigned int* readDataCh4, int noSamples);
bool ADS131A04_enableAnalogCircuits(void);
void ADS131A04_disableAnalogCircuits(void);
void ADS131A04_enableSamplingInterrupt(void);
void ADS131A04_disableSamplingInterrupt(void);
bool ADS131A04_writeSettings(void);
bool ADS131A04_waitForReadyWord(void);
bool ADS131A04_initSampling(void);
bool ADS131A04_stopSampling(void);
bool ADS131A04_singleSample(unsigned int* readDataCh1, unsigned int* readDataCh2, unsigned int* readDataCh3, unsigned int* readDataCh4, bool sampleGeophones);
bool ADS131A04_singleSampleFast(unsigned char* readDataCh1Byte1, unsigned char* readDataCh1Byte2, unsigned char* readDataCh1Byte3,
                                unsigned char* readDataCh2Byte1, unsigned char* readDataCh2Byte2, unsigned char* readDataCh2Byte3,
                                unsigned char* readDataCh3Byte1, unsigned char* readDataCh3Byte2, unsigned char* readDataCh3Byte3,
                                unsigned char* readDataCh4Byte1, unsigned char* readDataCh4Byte2, unsigned char* readDataCh4Byte3,
                                bool sampleGeophones);

// Bit level
bool ADS131A04_writeRegisterBit(unsigned char registerAddress, unsigned char value, int mask, int shift);
bool ADS131A04_readRegisterBit(unsigned char registerAddress, bool* value, int mask, int shift);

bool ADS131A04_read_F_OPC(bool* value);
bool ADS131A04_read_F_SPI(bool* value);
bool ADS131A04_read_F_ADCIN(bool* value);
bool ADS131A04_read_F_WDT(bool* value);
bool ADS131A04_read_F_RESYNC(bool* value);
bool ADS131A04_read_F_DRDY(bool* value);
bool ADS131A04_read_F_CHECK(bool* value);

bool ADS131A04_read_F_IN4P(bool* value);
bool ADS131A04_read_F_IN3P(bool* value);
bool ADS131A04_read_F_IN2P(bool* value);
bool ADS131A04_read_F_IN1P(bool* value);

bool ADS131A04_read_F_IN4N(bool* value);
bool ADS131A04_read_F_IN3N(bool* value);
bool ADS131A04_read_F_IN2N(bool* value);
bool ADS131A04_read_F_IN1N(bool* value);

bool ADS131A04_read_F_STARTUP(bool* value);
bool ADS131A04_read_F_CS(bool* value);
bool ADS131A04_read_F_FRAME(bool* value);

bool ADS131A04_write_VNCPEN(bool value);
bool ADS131A04_read_VNCPEN(bool* value);
bool ADS131A04_write_HRM(bool value);
bool ADS131A04_read_HRM(bool* value);
bool ADS131A04_write_VREF_4V(bool value);
bool ADS131A04_read_VREF_4V(bool* value);
bool ADS131A04_write_INT_REFEN(bool value);
bool ADS131A04_read_INT_REFEN(bool* value);
bool ADS131A04_write_COMP_TH(ADS131A04_COMP_TH_Values value);

bool ADS131A04_write_WDT_EN(bool value);
bool ADS131A04_read_WDT_EN(bool* value);
bool ADS131A04_write_CRC_MODE(bool value);
bool ADS131A04_read_CRC_MODE(bool* value);
bool ADS131A04_write_DNDLY(ADS131A04_DLY_Values value);
bool ADS131A04_write_HIZDLY(ADS131A04_DLY_Values value);
bool ADS131A04_write_FIXED(bool value);
bool ADS131A04_read_FIXED(bool* value);
bool ADS131A04_write_CRC_EN(bool value);
bool ADS131A04_read_CRC_EN(bool* value);

bool ADS131A04_write_CLKSRC(bool value);
bool ADS131A04_read_CLKSRC(bool* value);
bool ADS131A04_write_CLK_DIV(ADS131A04_CLK_DIV_Values value);

bool ADS131A04_write_ICLK_DIV(ADS131A04_ICLK_DIV_Values value);
bool ADS131A04_write_OSR(ADS131A04_OSR_Values value);

bool ADS131A04_write_ENA(ADS131A04_ENA_Values value);

bool ADS131A04_write_GAIN1(ADS131A04_GAIN_Values value);
bool ADS131A04_read_GAIN1(bool* value);

bool ADS131A04_write_GAIN2(ADS131A04_GAIN_Values value);
bool ADS131A04_read_GAIN2(bool* value);

bool ADS131A04_write_GAIN3(ADS131A04_GAIN_Values value);
bool ADS131A04_read_GAIN3(bool* value);

bool ADS131A04_write_GAIN4(ADS131A04_GAIN_Values value);
bool ADS131A04_read_GAIN4(bool* value);

#endif /* ADS131A04_ADC_ADS131A04_H_ */
